/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Calculations;

public class MathB {
    final double pi = Math.PI;
    final double e = Math.E;

    public static double distance(double x1, double y1, double x2, double y2) {
        return MathB.sqrt(MathB.sqr(x1 - x2) + MathB.sqr(y1 - y2));
    }

    public static double sqrt(double input) {
        return Math.sqrt(input);
    }

    public static double sqr(double input) {
        return input * input;
    }

    public static double cos(double input) {
        return Math.cos(input);
    }

    public static double sin(double input) {
        return Math.sin(input);
    }

    public static double lineAngle(double x, double y, double centerX, double centerY) {
        return (MathB.deg(Math.atan2(x - centerX, y - centerY)) + 270.0) % 360.0;
    }

    public static double deg(double radians) {
        return Math.toDegrees(radians);
    }

    public static double rad(double degrees) {
        return Math.toRadians(degrees);
    }

    public static double ln(double input) {
        return Math.log(input);
    }

    public static double log10(double input) {
        return Math.log10(input);
    }

    public static double pow(double number, double p) {
        return Math.pow(number, p);
    }

    public static double logA(double input, int base) {
        return MathB.ln(input) / MathB.ln(base);
    }

    public static long round(double input) {
        return Math.round(input);
    }

    public static int floor(double input) {
        return (int)input;
    }

    public static int ceil(double input) {
        return (int)(input + 1.0);
    }

    public static double min(double ... V) {
        double output = Double.MAX_VALUE;
        double[] dArray = V;
        int n = V.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            output = d < output ? d : output;
            ++n2;
        }
        return output;
    }

    public static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static double min(double a, double b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static long min(long a, long b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static short min(short a, short b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static double max(double a, double b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static long max(long a, long b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static short max(short a, short b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static int abs(int n) {
        if (n < 0) {
            n *= -1;
        }
        return n;
    }

    public static double abs(double n) {
        if (n < 0.0) {
            n *= -1.0;
        }
        return n;
    }

    public static int sign(int n) {
        if (n == 0) {
            return 0;
        }
        return n > 0 ? 1 : -1;
    }

    public static <T extends Comparable<T>> T max(T c1, T c2) {
        if (c1.compareTo(c2) < 0) {
            return c2;
        }
        return c1;
    }

    public static <T extends Comparable<T>> T min(T c1, T c2) {
        if (c1.compareTo(c2) > 0) {
            return c2;
        }
        return c1;
    }

    public static double adist(double val1, double val2) {
        return Math.abs(val1 - val2);
    }

    public static int LCM(Iterable<Integer> input) {
        int lcm = 1;
        for (int i : input) {
            lcm = MathB.LCM(lcm, i);
        }
        return lcm;
    }

    public static int LCM(int a, int b) {
        return a * b / MathB.Euclid(a, b);
    }

    private static int Euclid(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        return a;
    }

    public static double bound(double in, double min, double max) {
        return Math.min(max, Math.max(in, min));
    }

    public static int bound(int in, int min, int max) {
        return Math.min(max, Math.max(in, min));
    }
}

